/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.csl.DeclarationFinderImpl;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.OccurrenceHighlighter;
import org.netbeans.modules.php.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.php.editor.parser.PHPParseResult;

public class OccurrencesFinderImpl
extends OccurrencesFinder<PHPParseResult> {
    private Map<OffsetRange, ColoringAttributes> range2Attribs = Collections.emptyMap();
    private int caretPosition;
    private volatile boolean cancelled;

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.range2Attribs;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(PHPParseResult result, SchedulerEvent event) {
        if (this.cancelled) {
            this.cancelled = false;
            return;
        }
        HashMap<OffsetRange, ColoringAttributes> localRange2Attribs = new HashMap<OffsetRange, ColoringAttributes>();
        if (this.isMarkOccurrencesEnabled()) {
            for (OffsetRange r : this.compute(result, this.caretPosition)) {
                localRange2Attribs.put(r, ColoringAttributes.MARK_OCCURRENCES);
            }
        }
        if (this.cancelled) {
            this.cancelled = false;
            return;
        }
        this.range2Attribs = Collections.unmodifiableMap(localRange2Attribs);
    }

    public boolean isKeepMarks() {
        return MarkOccurencesSettings.getCurrentNode().getBoolean("KeepMarks", true);
    }

    public boolean isMarkOccurrencesEnabled() {
        return MarkOccurencesSettings.getCurrentNode().getBoolean("OnOff", true);
    }

    private Collection<OffsetRange> compute(PHPParseResult parseResult, int offset) {
        OffsetRange referenceSpan;
        TokenSequence<PHPTokenId> tokenSequence;
        TreeSet<OffsetRange> result = new TreeSet<OffsetRange>();
        TokenHierarchy tokenHierarchy = parseResult.getSnapshot().getTokenHierarchy();
        TokenSequence<PHPTokenId> tokenSequence2 = tokenSequence = tokenHierarchy != null ? LexUtilities.getPHPTokenSequence(tokenHierarchy, offset) : null;
        if (this.cancelled) {
            return Collections.emptyList();
        }
        OffsetRange offsetRange = referenceSpan = tokenSequence != null ? DeclarationFinderImpl.getReferenceSpan(tokenSequence, offset, parseResult.getModel()) : OffsetRange.NONE;
        if (!referenceSpan.equals((Object)OffsetRange.NONE)) {
            result.addAll(this.getOccurrences(parseResult.getModel(), referenceSpan));
        } else {
            OffsetRange referenceSpanForCodeMarkers;
            OccurrenceHighlighter highlighter = OccurrenceHighlighter.NONE;
            OffsetRange offsetRange2 = referenceSpanForCodeMarkers = tokenSequence != null ? OccurrencesFinderImpl.getReferenceSpanForCodeMarkers(tokenSequence, offset) : OffsetRange.NONE;
            if (!referenceSpanForCodeMarkers.equals((Object)OffsetRange.NONE)) {
                highlighter = this.getCodeMarkersHighlighter(parseResult.getModel(), referenceSpanForCodeMarkers);
            }
            result.addAll(highlighter.getRanges());
        }
        return result;
    }

    private Collection<OffsetRange> getOccurrences(Model model, OffsetRange referenceSpan) {
        PhpElementKind kind;
        EnumSet<Occurence.Accuracy[]> handledAccuracyFlags;
        TreeSet<OffsetRange> result = new TreeSet<OffsetRange>();
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(referenceSpan);
        if (this.cancelled) {
            return Collections.emptyList();
        }
        Occurence caretOccurence = occurencesSupport.getOccurence();
        if (this.cancelled) {
            return Collections.emptyList();
        }
        if (caretOccurence != null && (handledAccuracyFlags = EnumSet.of(Occurence.Accuracy.EXACT, new Occurence.Accuracy[]{Occurence.Accuracy.EXACT_TYPE, Occurence.Accuracy.MORE, Occurence.Accuracy.MORE_TYPES, Occurence.Accuracy.UNIQUE, Occurence.Accuracy.MORE_MEMBERS})).contains((Object)caretOccurence.degreeOfAccuracy()) && !(kind = caretOccurence.getKind()).equals((Object)PhpElementKind.INCLUDE)) {
            Collection<Occurence> allOccurences = caretOccurence.getAllOccurences();
            for (Occurence occurence : allOccurences) {
                if (!handledAccuracyFlags.contains((Object)caretOccurence.degreeOfAccuracy())) continue;
                result.add(occurence.getOccurenceRange());
            }
        }
        return result;
    }

    private OccurrenceHighlighter getCodeMarkersHighlighter(Model model, OffsetRange referenceSpanForCodeMarkers) {
        OccurrenceHighlighterImpl highlighter = new OccurrenceHighlighterImpl();
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(referenceSpanForCodeMarkers);
        if (this.cancelled) {
            return highlighter;
        }
        CodeMarker codeMarker = occurencesSupport.getCodeMarker();
        if (this.cancelled) {
            return highlighter;
        }
        if (codeMarker != null) {
            List<? extends CodeMarker> allMarkers = codeMarker.getAllMarkers();
            for (CodeMarker codeMarker2 : allMarkers) {
                codeMarker2.highlight(highlighter);
            }
        }
        return highlighter;
    }

    private static OffsetRange getReferenceSpanForCodeMarkers(TokenSequence<PHPTokenId> ts, int caretOffset) {
        Token token;
        PHPTokenId id;
        ts.move(caretOffset);
        if (ts.moveNext() && ((id = (PHPTokenId)(token = ts.token()).id()).equals((Object)PHPTokenId.PHP_FUNCTION) || id.equals((Object)PHPTokenId.PHP_RETURN))) {
            return new OffsetRange(ts.offset(), ts.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    private static final class OccurrenceHighlighterImpl
    implements OccurrenceHighlighter {
        private final Set<OffsetRange> offsetRanges = new TreeSet<OffsetRange>();

        private OccurrenceHighlighterImpl() {
        }

        @Override
        public void add(OffsetRange offsetRange) {
            this.offsetRanges.add(offsetRange);
        }

        @Override
        public Set<OffsetRange> getRanges() {
            return new TreeSet<OffsetRange>(this.offsetRanges);
        }
    }
}

